
<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
  <div class="max-w-7xl mx-auto px-4 py-8">
    
    <!-- Header Section -->
    <div class="mb-8 space-y-6">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
        <div class="space-y-2">
          <h1 class="text-4xl lg:text-5xl font-bold bg-gradient-to-r from-blue-600 via-indigo-600 to-purple-600 bg-clip-text text-transparent">
            Manajemen Kandidat
          </h1>
          <p class="text-slate-600 text-lg">Kelola data kandidat OSIS untuk periode aktif</p>
        </div>
        <a href="<?php echo e(route('admin.candidates.create')); ?>"
           class="inline-flex items-center gap-2 bg-gradient-to-r from-emerald-500 to-teal-600 hover:from-emerald-600 hover:to-teal-700 text-white px-6 py-3 rounded-xl font-medium shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
          </svg>
          Tambah Kandidat
        </a>
      </div>

      <!-- Period Info & Search -->
      <div class="flex flex-col lg:flex-row gap-4 items-start lg:items-end">
        <!-- Period Badge -->
        <div class="bg-white/80 backdrop-blur-sm rounded-2xl border border-white/50 px-6 py-4 shadow-sm">
          <div class="flex items-center gap-3">
            <div class="w-3 h-3 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-full animate-pulse"></div>
            <div>
              <span class="text-sm text-slate-500 block">Periode Aktif</span>
              <span class="font-bold text-blue-600 text-lg"><?php echo e($period->name ?? 'Belum ada periode aktif'); ?></span>
            </div>
          </div>
        </div>

        <!-- Search Form -->
        <form method="GET" class="flex flex-wrap gap-3 flex-1 lg:justify-end">
          <div class="relative">
            <svg class="absolute left-3 top-1/2 transform -translate-y-1/2 w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
            </svg>
            <input name="q" value="<?php echo e($q); ?>" placeholder="Cari nama kandidat atau kelas..." 
                   class="pl-10 pr-4 py-2.5 bg-white/80 backdrop-blur-sm border border-slate-200 rounded-xl text-sm placeholder-slate-400 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all w-64">
          </div>
          <button type="submit" class="px-4 py-2.5 bg-blue-600 hover:bg-blue-700 text-white rounded-xl font-medium transition-colors">
            Cari
          </button>
          <?php if($q): ?>
            <a href="<?php echo e(route('admin.candidates.index')); ?>" 
               class="px-4 py-2.5 bg-white/80 backdrop-blur-sm border border-slate-200 hover:border-slate-300 text-slate-600 rounded-xl font-medium transition-all">
              Reset
            </a>
          <?php endif; ?>
        </form>
      </div>
    </div>

    <!-- Success Message -->
    <?php if(session('status')): ?>
      <div class="mb-8 p-4 bg-gradient-to-r from-green-50 to-emerald-50 border-l-4 border-green-500 rounded-r-xl shadow-sm">
        <div class="flex items-center gap-3">
          <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
          <span class="text-green-800 font-medium"><?php echo e(session('status')); ?></span>
        </div>
      </div>
    <?php endif; ?>

    <!-- Search Results Info -->
    <?php if($q): ?>
      <div class="mb-6 p-4 bg-blue-50 rounded-xl border border-blue-200">
        <p class="text-blue-700">
          <span class="font-medium">Hasil pencarian untuk:</span> "<?php echo e($q); ?>" 
          <span class="text-sm">(<?php echo e($candidates->total()); ?> kandidat ditemukan)</span>
        </p>
      </div>
    <?php endif; ?>

    <!-- Candidates Grid -->
    <div class="grid sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
      <?php $__empty_1 = true; $__currentLoopData = $candidates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <div class="group bg-white/80 backdrop-blur-sm border border-white/50 rounded-2xl shadow-sm hover:shadow-xl hover:shadow-blue-500/10 transform hover:-translate-y-1 transition-all duration-300">
        <!-- Photo Section -->
        <div class="aspect-[4/3] bg-gradient-to-br from-slate-100 to-slate-200 overflow-hidden rounded-t-2xl relative">
          <?php if($c->photo_url): ?>
            <img src="<?php echo e($c->photo_url); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300" alt="<?php echo e($c->name); ?>">
          <?php else: ?>
            <div class="w-full h-full flex flex-col items-center justify-center text-slate-400">
              <svg class="w-12 h-12 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
              </svg>
              <span class="text-xs">Tidak ada foto</span>
            </div>
          <?php endif; ?>
          
          <!-- Status Badge -->
          <div class="absolute top-3 right-3">
            <span class="px-2.5 py-1 rounded-full text-xs font-medium backdrop-blur-sm <?php echo e($c->is_active ? 'bg-green-100/90 text-green-700 border border-green-200' : 'bg-slate-100/90 text-slate-600 border border-slate-200'); ?>">
              <?php echo e($c->is_active ? 'Aktif' : 'Nonaktif'); ?>

            </span>
          </div>
        </div>

        <!-- Content Section -->
        <div class="p-5 space-y-4">
          <div class="space-y-1">
            <div class="flex items-center gap-2">
              <svg class="w-4 h-4 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-4m-5 0H3m2 0h4M9 7h6m-6 4h6m-2 4h2"/>
              </svg>
              <span class="text-xs text-slate-500 font-medium"><?php echo e($c->class ?? 'Kelas tidak diketahui'); ?></span>
            </div>
            <h3 class="text-lg font-bold text-slate-900 group-hover:text-blue-600 transition-colors"><?php echo e($c->name); ?></h3>
          </div>

          <?php if($c->vision): ?>
            <div class="space-y-1">
              <p class="text-xs font-semibold text-slate-500 uppercase tracking-wider">Visi</p>
              <p class="text-sm text-slate-600 line-clamp-3 leading-relaxed"><?php echo e($c->vision); ?></p>
            </div>
          <?php endif; ?>

          <!-- Action Buttons -->
          <div class="flex gap-2 pt-2 border-t border-slate-100">
            <a href="<?php echo e(route('admin.candidates.edit',$c)); ?>"
               class="flex-1 px-3 py-2 rounded-lg text-xs font-medium bg-blue-50 hover:bg-blue-100 text-blue-700 border border-blue-200 hover:border-blue-300 transition-all text-center">
              <svg class="w-4 h-4 mx-auto mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
              </svg>
              Edit
            </a>
            <form method="POST" action="<?php echo e(route('admin.candidates.destroy',$c)); ?>"
                  onsubmit="return confirm('Apakah Anda yakin ingin menghapus kandidat <?php echo e($c->name); ?>? Tindakan ini tidak dapat dibatalkan.')">
              <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
              <button type="submit" class="px-3 py-2 rounded-lg text-xs font-medium bg-rose-50 hover:bg-rose-100 text-rose-700 border border-rose-200 hover:border-rose-300 transition-all">
                <svg class="w-4 h-4 mx-auto mb-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                </svg>
                Hapus
              </button>
            </form>
          </div>
        </div>
      </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-span-full bg-white/80 backdrop-blur-sm border border-slate-200 rounded-2xl p-12 text-center">
          <svg class="w-16 h-16 mx-auto mb-4 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
          </svg>
          <h3 class="text-lg font-semibold text-slate-600 mb-2">Belum Ada Kandidat</h3>
          <p class="text-slate-500 mb-6">
            <?php if($q): ?>
              Tidak ada kandidat yang sesuai dengan pencarian "<?php echo e($q); ?>".
            <?php else: ?>
              Mulai dengan menambahkan kandidat OSIS pertama Anda.
            <?php endif; ?>
          </p>
          <?php if(!$q): ?>
            <a href="<?php echo e(route('admin.candidates.create')); ?>"
               class="inline-flex items-center gap-2 bg-gradient-to-r from-blue-500 to-indigo-600 hover:from-blue-600 hover:to-indigo-700 text-white px-6 py-3 rounded-xl font-medium shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all duration-200">
              <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
              </svg>
              Tambah Kandidat Pertama
            </a>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </div>

    <!-- Pagination -->
    <?php if($candidates->hasPages()): ?>
      <div class="mt-8 flex justify-center">
        <div class="bg-white/80 backdrop-blur-sm rounded-2xl border border-white/50 p-2 shadow-sm">
          <?php echo e($candidates->links()); ?>

        </div>
      </div>
    <?php endif; ?>
  </div>
</div>

<!-- Custom Styles for line-clamp if not available -->
<style>
.line-clamp-2 {
  display: -webkit-box;
  -webkit-line-clamp: 2;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
.line-clamp-3 {
  display: -webkit-box;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
  overflow: hidden;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\osis-vote\resources\views/admin/candidates/index.blade.php ENDPATH**/ ?>