<?php if(session()->has('status') || session()->has('error') || session()->has('info')): ?>
    <!-- Modern Toast Container -->
    <div id="toast-container" class="fixed top-5 right-5 z-50 space-y-2"></div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let message = '';
            let type = '';
            let icon = '';
            
            <?php if(session()->has('status')): ?>
                message = "<?php echo e(session('status')); ?>";
                type = 'success';
                icon = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>`;
            <?php elseif(session()->has('error')): ?>
                message = "<?php echo e(session('error')); ?>";
                type = 'error';
                icon = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                </svg>`;
            <?php elseif(session()->has('info')): ?>
                message = "<?php echo e(session('info')); ?>";
                type = 'info';
                icon = `<svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                </svg>`;
            <?php endif; ?>

            showModernToast(message, type, icon);
        });

        function showModernToast(message, type, icon) {
            const container = document.getElementById('toast-container');
            
            // Color classes based on type
            const typeClasses = {
                success: 'bg-white border-l-4 border-green-500 text-green-800 shadow-green-100',
                error: 'bg-white border-l-4 border-red-500 text-red-800 shadow-red-100',
                info: 'bg-white border-l-4 border-blue-500 text-blue-800 shadow-blue-100'
            };

            const iconColors = {
                success: 'text-green-500',
                error: 'text-red-500',
                info: 'text-blue-500'
            };

            // Create toast element
            const toast = document.createElement('div');
            toast.className = `
                ${typeClasses[type]} 
                p-4 rounded-lg shadow-lg transform transition-all duration-300 ease-in-out
                max-w-md backdrop-blur-sm border border-gray-100
                animate-slide-in-right
            `;
            
            toast.innerHTML = `
                <div class="flex items-start">
                    <div class="flex-shrink-0 ${iconColors[type]} mt-0.5">
                        ${icon}
                    </div>
                    <div class="ml-3 flex-1">
                        <p class="text-sm font-medium leading-5">
                            ${message}
                        </p>
                    </div>
                    <div class="ml-4 flex-shrink-0 flex">
                        <button class="inline-flex text-gray-400 hover:text-gray-600 focus:outline-none focus:text-gray-600 transition ease-in-out duration-150" onclick="closeToast(this)">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                            </svg>
                        </button>
                    </div>
                </div>
                <!-- Progress bar -->
                <div class="mt-2 w-full bg-gray-200 rounded-full h-1 overflow-hidden">
                    <div class="progress-bar h-full ${type === 'success' ? 'bg-green-500' : type === 'error' ? 'bg-red-500' : 'bg-blue-500'} rounded-full transition-all duration-5000 ease-linear" style="width: 100%"></div>
                </div>
            `;

            container.appendChild(toast);

            // Start progress animation
            setTimeout(() => {
                const progressBar = toast.querySelector('.progress-bar');
                progressBar.style.width = '0%';
            }, 100);

            // Auto remove after 5 seconds
            setTimeout(() => {
                removeToast(toast);
            }, 5000);

            // Hover to pause
            toast.addEventListener('mouseenter', () => {
                const progressBar = toast.querySelector('.progress-bar');
                progressBar.style.animationPlayState = 'paused';
            });

            toast.addEventListener('mouseleave', () => {
                const progressBar = toast.querySelector('.progress-bar');
                progressBar.style.animationPlayState = 'running';
            });
        }

        function closeToast(button) {
            const toast = button.closest('.animate-slide-in-right') || button.closest('[class*="bg-white"]');
            removeToast(toast);
        }

        function removeToast(toast) {
            toast.style.transform = 'translateX(100%)';
            toast.style.opacity = '0';
            setTimeout(() => {
                if (toast.parentNode) {
                    toast.parentNode.removeChild(toast);
                }
            }, 300);
        }
    </script>

    <style>
        @keyframes slide-in-right {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        .animate-slide-in-right {
            animation: slide-in-right 0.3s ease-out;
        }

        .duration-5000 {
            transition-duration: 5000ms;
        }

        /* Glass morphism effect */
        .backdrop-blur-sm {
            backdrop-filter: blur(4px);
        }

        /* Hover effects */
        .shadow-green-100 {
            box-shadow: 0 10px 25px -5px rgba(34, 197, 94, 0.1), 0 10px 10px -5px rgba(34, 197, 94, 0.04);
        }

        .shadow-red-100 {
            box-shadow: 0 10px 25px -5px rgba(239, 68, 68, 0.1), 0 10px 10px -5px rgba(239, 68, 68, 0.04);
        }

        .shadow-blue-100 {
            box-shadow: 0 10px 25px -5px rgba(59, 130, 246, 0.1), 0 10px 10px -5px rgba(59, 130, 246, 0.04);
        }
    </style>
<?php endif; ?><?php /**PATH C:\laragon\www\osis-vote\resources\views/components/toast-notification.blade.php ENDPATH**/ ?>