

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-4">
  <div class="max-w-7xl mx-auto">
    
    <div class="mb-6 flex items-center justify-between">
      <div>
        <h1 class="text-3xl font-bold bg-gradient-to-r from-blue-600 to-indigo-600 bg-clip-text text-transparent">
          SMAN 01 CONTOH
        </h1>
        <p class="text-slate-600">Sistem Voting Modern</p>
      </div>
      <div class="bg-white rounded-full px-4 py-2 shadow-sm border">
        <span class="text-sm text-slate-600">Total Kandidat: </span>
        <span id="stat-candidate-count-header" class="font-bold text-blue-600"><?php echo e($candidateCount); ?></span>
      </div>
    </div>

    
    <div class="grid lg:grid-cols-4 gap-4 mb-6">
      <div class="rounded-2xl overflow-hidden shadow-lg border border-slate-200">
        <div class="bg-gradient-to-r from-blue-600 to-indigo-600 p-5 text-white">
          <div class="text-sm opacity-75">Periode Aktif</div>
          <div class="mt-1 text-2xl font-bold"><?php echo e($period->name ?? 'Tidak ada'); ?></div>
        </div>
        <div class="p-4 text-slate-700">
          <div class="flex items-center gap-2 text-sm">
            <span class="w-2 h-2 rounded-full bg-emerald-500"></span> Periode Sedang Berjalan
          </div>
        </div>
      </div>
      <div class="rounded-2xl overflow-hidden shadow-lg border border-slate-200">
        <div class="bg-gradient-to-r from-emerald-600 to-teal-600 p-5 text-white">
          <div class="text-sm opacity-80">Pemilih Terdaftar</div>
          <div id="stat-total-voters" class="mt-1 text-3xl font-bold"><?php echo e($totalVoters); ?></div>
        </div>
        <div class="p-4 text-slate-700 text-sm">Total Pemilih Aktif</div>
      </div>
      <div class="rounded-2xl overflow-hidden shadow-lg border border-slate-200">
        <div class="bg-gradient-to-r from-fuchsia-600 to-pink-600 p-5 text-white">
          <div class="text-sm opacity-80">Sudah Memilih</div>
          <div id="stat-voted-count" class="mt-1 text-3xl font-bold"><?php echo e($votedCount); ?></div>
        </div>
        <div class="p-4">
          <div class="text-slate-700 text-sm mb-2">Partisipasi</div>
          <div class="h-2 rounded bg-slate-200 overflow-hidden">
            <div id="stat-participation-bar" class="h-full bg-fuchsia-500" style="width: <?php echo e($totalVoters > 0 ? round(($votedCount/$totalVoters)*100,1) : 0); ?>%"></div>
          </div>
          <div id="stat-participation-text" class="mt-1 text-xs text-slate-500"><?php echo e($totalVoters > 0 ? round(($votedCount/$totalVoters)*100,1) : 0); ?>%</div>
        </div>
      </div>
      <div class="rounded-2xl overflow-hidden shadow-lg border border-slate-200">
        <div class="bg-gradient-to-r from-amber-500 to-orange-500 p-5 text-white">
          <div class="text-sm opacity-80">Total Kandidat</div>
          <div id="stat-candidate-count" class="mt-1 text-3xl font-bold"><?php echo e($candidateCount); ?></div>
        </div>
        <div class="p-4 text-slate-700 text-sm">Kandidat Terdaftar</div>
      </div>
    </div>

    
    <div class="grid lg:grid-cols-2 gap-6">
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
        <div class="bg-slate-900 text-white p-5">
          <div class="text-lg font-semibold">Visualisasi Suara</div>
          <div class="text-slate-300 text-sm">Grafik perolehan suara</div>
        </div>
        <div id="visualisation-container" class="p-4 space-y-3">
          <?php $__empty_1 = true; $__currentLoopData = $candidates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="flex items-center gap-3">
              <div class="w-6 h-6 rounded-full bg-slate-100 text-slate-700 grid place-items-center text-xs font-bold"><?php echo e($loop->iteration); ?></div>
              <div class="flex-1">
                <div class="text-sm font-medium text-slate-800"><?php echo e($cand->name); ?></div>
                <div class="mt-1 h-1.5 rounded bg-slate-200 overflow-hidden">
                  <div class="h-full bg-blue-600" style="width: <?php echo e($cand->percentage); ?>%"></div>
                </div>
              </div>
              <div class="w-10 text-right text-sm font-semibold text-slate-900"><?php echo e($cand->votes); ?></div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="text-slate-500 text-sm">Belum ada kandidat.</div>
          <?php endif; ?>
        </div>
      </div>
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
        <div class="bg-slate-900 text-white p-5 flex items-center justify-between">
          <div>
            <div class="text-lg font-semibold">Rekap Perolehan Suara</div>
            <div class="text-slate-300 text-sm">Data real-time hasil pemilihan</div>
          </div>
          <div id="recap-total-votes" class="bg-white/10 text-white text-xs px-3 py-1 rounded-full">Total: <?php echo e($totalVotes); ?> suara</div>
        </div>
        <div class="overflow-x-auto">
          <table class="w-full">
            <thead class="bg-slate-50 border-b border-slate-200">
              <tr>
                <th class="px-6 py-3 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Nomor</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Nama Kandidat</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Perolehan Suara</th>
                <th class="px-6 py-3 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Persentase</th>
              </tr>
            </thead>
            <tbody id="recap-table-body" class="divide-y divide-slate-200">
              <?php $__empty_1 = true; $__currentLoopData = $candidates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
              <tr class="hover:bg-slate-50">
                <td class="px-6 py-3"><span class="inline-flex items-center justify-center w-7 h-7 rounded-full bg-slate-100 text-slate-700 text-xs font-bold"><?php echo e($loop->iteration); ?></span></td>
                <td class="px-6 py-3"><div class="font-medium text-slate-900"><?php echo e($cand->name); ?></div><div class="text-xs text-slate-500"><?php echo e($cand->class ?? ''); ?></div></td>
                <td class="px-6 py-3"><div class="flex items-center gap-2"><span class="text-slate-900 font-semibold"><?php echo e($cand->votes); ?></span><span class="text-xs text-slate-500">suara</span></div></td>
                <td class="px-6 py-3"><div class="text-slate-900 font-semibold"><?php echo e(number_format($cand->percentage, 1)); ?>%</div><div class="mt-1 h-1.5 rounded bg-slate-200 overflow-hidden"><div class="h-full bg-emerald-500" style="width: <?php echo e($cand->percentage); ?>%"></div></div></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <tr><td colspan="4" class="px-6 py-6 text-center text-slate-500">Belum ada data kandidat.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Fungsi untuk memperbarui HTML dengan data baru
    function updateDashboard(data) {
        // Update kartu statistik
        document.getElementById('stat-candidate-count-header').innerText = data.candidateCount;
        document.getElementById('stat-total-voters').innerText = data.totalVoters;
        document.getElementById('stat-voted-count').innerText = data.votedCount;
        document.getElementById('stat-candidate-count').innerText = data.candidateCount;

        let participation = data.totalVoters > 0 ? ((data.votedCount / data.totalVoters) * 100).toFixed(1) : 0;
        document.getElementById('stat-participation-bar').style.width = participation + '%';
        document.getElementById('stat-participation-text').innerText = participation + '%';

        // Update total suara
        document.getElementById('recap-total-votes').innerText = 'Total: ' + data.totalVotes + ' suara';

        // Update tabel rekapitulasi dan visualisasi
        const recapBody = document.getElementById('recap-table-body');
        const vizContainer = document.getElementById('visualisation-container');
        recapBody.innerHTML = '';
        vizContainer.innerHTML = '';

        if (data.candidates.length === 0) {
            recapBody.innerHTML = '<tr><td colspan="4" class="px-6 py-6 text-center text-slate-500">Belum ada data kandidat.</td></tr>';
            vizContainer.innerHTML = '<div class="text-slate-500 text-sm">Belum ada kandidat.</div>';
        } else {
            data.candidates.forEach((cand, index) => {
                // Buat baris baru untuk tabel rekap
                const recapRow = `
                    <tr class="hover:bg-slate-50">
                        <td class="px-6 py-3"><span class="inline-flex items-center justify-center w-7 h-7 rounded-full bg-slate-100 text-slate-700 text-xs font-bold">${index + 1}</span></td>
                        <td class="px-6 py-3"><div class="font-medium text-slate-900">${cand.name}</div><div class="text-xs text-slate-500">${cand.class ?? ''}</div></td>
                        <td class="px-6 py-3"><div class="flex items-center gap-2"><span class="text-slate-900 font-semibold">${cand.votes}</span><span class="text-xs text-slate-500">suara</span></div></td>
                        <td class="px-6 py-3"><div class="text-slate-900 font-semibold">${cand.percentage.toFixed(1)}%</div><div class="mt-1 h-1.5 rounded bg-slate-200 overflow-hidden"><div class="h-full bg-emerald-500" style="width: ${cand.percentage}%"></div></div></td>
                    </tr>`;
                recapBody.innerHTML += recapRow;

                // Buat baris baru untuk visualisasi
                const vizRow = `
                    <div class="flex items-center gap-3">
                        <div class="w-6 h-6 rounded-full bg-slate-100 text-slate-700 grid place-items-center text-xs font-bold">${index + 1}</div>
                        <div class="flex-1">
                            <div class="text-sm font-medium text-slate-800">${cand.name}</div>
                            <div class="mt-1 h-1.5 rounded bg-slate-200 overflow-hidden"><div class="h-full bg-blue-600" style="width: ${cand.percentage}%"></div></div>
                        </div>
                        <div class="w-10 text-right text-sm font-semibold text-slate-900">${cand.votes}</div>
                    </div>`;
                vizContainer.innerHTML += vizRow;
            });
        }
    }

    // Fungsi untuk mengambil data dari server
    async function fetchData() {
        try {
            const response = await fetch("<?php echo e(route('admin.dashboard.stats')); ?>");
            const data = await response.json();
            updateDashboard(data);
        } catch (error) {
            console.error('Gagal mengambil data statistik:', error);
        }
    }

    // Jalankan fetchData setiap 5 detik
    setInterval(fetchData, 5000);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\osis-vote\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>