<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Terima Kasih!</title>
    
    <meta http-equiv="refresh" content="5;url={{ route('voter.login') }}">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @keyframes countdown {
            from { width: 100%; }
            to { width: 0%; }
        }
        .countdown-bar {
            animation: countdown 5s linear forwards;
        }
        
        @keyframes checkmark {
            0% {
                transform: scale(0);
                opacity: 0;
            }
            50% {
                transform: scale(1.2);
                opacity: 1;
            }
            100% {
                transform: scale(1);
                opacity: 1;
            }
        }
        
        .checkmark-animation {
            animation: checkmark 0.8s ease-out forwards;
        }
        
        @keyframes fade-in-up {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .fade-in-up {
            animation: fade-in-up 0.6s ease-out forwards;
        }
        
        .delay-1 { animation-delay: 0.2s; opacity: 0; }
        .delay-2 { animation-delay: 0.4s; opacity: 0; }
        .delay-3 { animation-delay: 0.6s; opacity: 0; }
    </style>
</head>
<body class="min-h-screen bg-gradient-to-br from-slate-50 to-slate-100 flex items-center justify-center p-4">

    <div class="bg-white rounded-3xl border border-slate-200 shadow-sm p-12 max-w-md w-full text-center">
        <!-- Success Icon -->
        <div class="w-20 h-20 bg-green-50 rounded-full flex items-center justify-center mx-auto mb-6 checkmark-animation">
            <svg class="w-10 h-10 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
        </div>
        
        <!-- Title -->
        <h1 class="text-3xl font-bold text-slate-900 mb-3 fade-in-up delay-1">
            Terima Kasih!
        </h1>
        
        <!-- Message -->
        <p class="text-slate-600 text-lg mb-8 leading-relaxed fade-in-up delay-2">
            Suara Anda telah berhasil direkam.<br>
            Partisipasi Anda sangat berarti untuk demokrasi.
        </p>
        
        <!-- Countdown Section -->
        <div class="fade-in-up delay-3">
            <div class="bg-slate-50 rounded-2xl p-4 mb-6">
                <p class="text-slate-500 text-sm mb-3">
                    Anda akan diarahkan kembali ke halaman login dalam
                </p>
                <div id="countdown-text" class="text-2xl font-bold text-slate-900 mb-3">5</div>
                <div class="w-full bg-slate-200 rounded-full h-2 overflow-hidden">
                    <div class="bg-blue-600 h-2 rounded-full countdown-bar"></div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Countdown timer
        let countdown = 5;
        const countdownElement = document.getElementById('countdown-text');
        
        const timer = setInterval(() => {
            countdown--;
            countdownElement.textContent = countdown;
            
            if (countdown <= 0) {
                clearInterval(timer);
                countdownElement.textContent = '0';
            }
        }, 1000);
        
        // Add smooth transitions to animations
        document.addEventListener('DOMContentLoaded', function() {
            const elements = document.querySelectorAll('.fade-in-up');
            elements.forEach(element => {
                element.style.animationFillMode = 'forwards';
            });
        });
    </script>

</body>
</html>