@extends('layouts.voter')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 to-indigo-100 p-4 sm:p-6 lg:p-8">
    <div class="max-w-7xl mx-auto">

        <div class="text-center mb-10">
            <h1 class="text-4xl md:text-5xl font-bold bg-gradient-to-r from-blue-600 to-indigo-600 bg-clip-text text-transparent mb-4">
                Pilih Kandidat Ketua OSIS
            </h1>
            {{-- PERUBAHAN DI SINI --}}
            <div class="inline-block px-4 py-2 bg-yellow-100 rounded-full border border-yellow-200">
                <p class="text-yellow-800 text-md">
                    <span class="font-medium">Periode:</span> 
                    <span class="font-bold">{{ $period->name ?? '-' }}</span>
                </p>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">

            @forelse($candidates as $candidate)
                <div class="candidate-card bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden transform transition-all duration-300 hover:scale-105 hover:shadow-2xl">
                    <div class="h-64 overflow-hidden">
                        <img src="{{ $candidate->photo_url ?? 'https://via.placeholder.com/400x300' }}" alt="Foto {{ $candidate->name }}" class="w-full h-full object-cover transition-transform duration-300 group-hover:scale-110">
                    </div>
                    <div class="p-6 text-center">
                        <h3 class="font-bold text-2xl text-slate-900">{{ $candidate->name }}</h3>
                        <p class="text-md text-slate-500 mb-6">{{ $candidate->class }}</p>
                        
                        <button 
                            type="button" 
                            onclick="showConfirmationModal('{{ $candidate->id }}', '{{ $candidate->name }}')"
                            class="w-full bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-xl font-semibold transition-all duration-200 transform hover:scale-105 shadow-md hover:shadow-lg">
                            Pilih Kandidat Ini
                        </button>
                    </div>
                </div>
            @empty
                <div class="md:col-span-3 text-center p-12 bg-white rounded-2xl shadow-lg border border-slate-200">
                    <svg class="w-16 h-16 mx-auto text-slate-300 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                    <h3 class="text-xl font-semibold text-slate-700">Belum Ada Kandidat</h3>
                    <p class="text-slate-500 mt-1">Belum ada kandidat yang terdaftar untuk periode pemilihan ini.</p>
                </div>
            @endforelse
        </div>
    </div>
</div>

<div id="confirmation-modal" class="fixed inset-0 bg-black bg-opacity-50 backdrop-blur-sm flex items-center justify-center p-4 z-50 hidden transition-opacity duration-300">
    <div id="modal-content" class="bg-white rounded-2xl shadow-2xl w-full max-w-sm p-8 text-center transform transition-all duration-300 scale-95 opacity-0">
        <h2 class="text-2xl font-bold text-slate-900 mb-2">Konfirmasi Pilihan Anda</h2>
        <p class="text-slate-600 mb-6">Apakah Anda yakin ingin memilih <strong id="modal-candidate-name" class="text-blue-600"></strong>?</p>
        
        <form id="vote-form" method="POST" action="{{ route('vote.cast') }}" class="space-y-4">
            @csrf
            <input type="hidden" name="candidate_id" id="modal-candidate-id">
            
            <button 
                type="submit" 
                class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-3 px-4 rounded-xl transition-colors duration-200 shadow-lg hover:shadow-blue-500/50 transform hover:scale-105">
                Ya, Saya Yakin
            </button>
            <button 
                type="button" 
                onclick="hideConfirmationModal()"
                class="w-full bg-slate-100 hover:bg-slate-200 text-slate-700 font-semibold py-3 px-4 rounded-xl transition-colors duration-200">
                Batal
            </button>
        </form>
    </div>
</div>

@push('scripts')
<script>
    const modal = document.getElementById('confirmation-modal');
    const modalContent = document.getElementById('modal-content');
    const modalCandidateName = document.getElementById('modal-candidate-name');
    const modalCandidateId = document.getElementById('modal-candidate-id');

    function showConfirmationModal(candidateId, candidateName) {
        modalCandidateName.textContent = candidateName;
        modalCandidateId.value = candidateId;

        modal.classList.remove('hidden');
        setTimeout(() => {
            modal.style.opacity = '1';
            modalContent.classList.remove('scale-95', 'opacity-0');
        }, 10);
    }

    function hideConfirmationModal() {
        modal.style.opacity = '0';
        modalContent.classList.add('scale-95', 'opacity-0');
        setTimeout(() => {
            modal.classList.add('hidden');
        }, 300);
    }
</script>
@endpush

@push('styles')
<style>
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .candidate-card {
        animation: fadeInUp 0.5s ease-out forwards;
        opacity: 0;
    }
    
    @for ($i = 0; $i < 10; $i++)
        .candidate-card:nth-child({{ $i + 1 }}) {
            animation-delay: {{ $i * 0.1 }}s;
        }
    @endfor
</style>
@endpush