<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!-- Optional: Dark mode (otomatis ikut sistem, bisa diubah ke toggle jika perlu) -->
    <script>
      // Pakai preferensi user di localStorage, fallback ke system
      const savedTheme = localStorage.getItem('theme');
      const systemDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
      if ((savedTheme === 'dark') || (!savedTheme && systemDark)) {
        document.documentElement.classList.add('dark');
      }
    </script>
  </head>
  <body class="font-sans antialiased bg-gradient-to-b from-slate-50 to-white dark:from-slate-900 dark:to-slate-950 text-slate-900 dark:text-slate-100">
    <div class="min-h-screen grid place-items-center p-6">
      <div class="w-full max-w-md">
        <!-- Logo / Brand -->
        <div class="flex flex-col items-center gap-3 mb-8">
          <a href="/" class="inline-flex h-14 w-14 items-center justify-center rounded-2xl bg-white/70 dark:bg-slate-800/60 shadow-sm ring-1 ring-slate-200/60 dark:ring-slate-700/60 backdrop-blur">
            <x-application-logo class="w-8 h-8 text-slate-700 dark:text-slate-200" />
          </a>
          <h1 class="text-lg font-semibold tracking-tight text-slate-800 dark:text-slate-100">
            {{ config('app.name', 'Laravel') }}
          </h1>
        </div>

        <!-- Card -->
        <div class="rounded-2xl border border-slate-200/80 dark:border-slate-800 bg-white/90 dark:bg-slate-900/60 shadow-sm backdrop-blur p-6">
          {{ $slot }}
        </div>

        <!-- Footer kecil (opsional) -->
        <p class="mt-6 text-center text-xs text-slate-500 dark:text-slate-400">
          © {{ now()->year }} {{ config('app.name', 'Laravel') }}
        </p>
      </div>
    </div>

    <!-- Optional: fungsi toggle tema manual (pakai tombol sendiri jika ingin) -->
    <script>
      window.toggleTheme = function() {
        const root = document.documentElement;
        const isDark = root.classList.toggle('dark');
        localStorage.setItem('theme', isDark ? 'dark' : 'light');
      }
    </script>
  </body>
</html>
