@extends('layouts.app')
@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-4">
  <div class="max-w-7xl mx-auto">
    <!-- Header Section -->
    <div class="mb-8">
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-4xl font-bold bg-gradient-to-r from-blue-600 to-indigo-600 bg-clip-text text-transparent mb-2">
            Dashboard Admin
          </h1>
          <p class="text-slate-600">Pantau aktivitas pemilihan secara real-time</p>
        </div>
        <div class="flex items-center gap-3">
          <div class="bg-white rounded-full px-4 py-2 shadow-sm border flex items-center gap-2">
            <div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div>
            <span class="text-sm text-slate-600">Live Data</span>
          </div>
          <div class="bg-white rounded-full px-4 py-2 shadow-sm border">
            <span class="text-sm text-slate-600" id="current-time"></span>
          </div>
        </div>
      </div>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
      <!-- Periode Aktif -->
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden group hover:shadow-xl transition-all duration-300">
        <div class="bg-gradient-to-r from-blue-500 to-cyan-600 p-6 text-white">
          <div class="flex items-center justify-between">
            <div>
              <p class="text-blue-100 text-sm font-medium">Periode Aktif</p>
              <p class="text-2xl font-bold mt-1">{{ $period->name ?? 'Tidak Aktif' }}</p>
            </div>
            <div class="bg-white/20 p-3 rounded-full">
              <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"/>
              </svg>
            </div>
          </div>
        </div>
        <div class="p-4">
          @if($period)
            <div class="flex items-center text-sm text-green-600">
              <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
              </svg>
              Periode Sedang Berjalan
            </div>
          @else
            <div class="flex items-center text-sm text-amber-600">
              <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
              </svg>
              Tidak Ada Periode Aktif
            </div>
          @endif
        </div>
      </div>

      <!-- Pemilih Terdaftar -->
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden group hover:shadow-xl transition-all duration-300">
        <div class="bg-gradient-to-r from-emerald-500 to-teal-600 p-6 text-white">
          <div class="flex items-center justify-between">
            <div>
              <p class="text-emerald-100 text-sm font-medium">Pemilih Terdaftar</p>
              <p class="text-2xl font-bold mt-1">{{ number_format($stats['pemilih']) }}</p>
            </div>
            <div class="bg-white/20 p-3 rounded-full">
              <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
              </svg>
            </div>
          </div>
        </div>
        <div class="p-4">
          <div class="flex items-center text-sm text-emerald-600">
            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"/>
            </svg>
            Total Pemilih Aktif
          </div>
        </div>
      </div>

      <!-- Sudah Memilih -->
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden group hover:shadow-xl transition-all duration-300">
        <div class="bg-gradient-to-r from-purple-500 to-pink-600 p-6 text-white">
          <div class="flex items-center justify-between">
            <div>
              <p class="text-purple-100 text-sm font-medium">Sudah Memilih</p>
              <p class="text-2xl font-bold mt-1">{{ number_format($stats['sudah_memilih']) }}</p>
            </div>
            <div class="bg-white/20 p-3 rounded-full">
              <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
              </svg>
            </div>
          </div>
        </div>
        <div class="p-4">
          <div class="flex items-center justify-between">
            <div class="flex items-center text-sm text-purple-600">
              <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-8.293l-3-3a1 1 0 00-1.414 0l-3 3a1 1 0 001.414 1.414L9 9.414V13a1 1 0 102 0V9.414l1.293 1.293a1 1 0 001.414-1.414z" clip-rule="evenodd"/>
              </svg>
              Partisipasi
            </div>
            @if($stats['pemilih'] > 0)
              <span class="text-sm font-bold text-purple-600">
                {{ number_format(($stats['sudah_memilih'] / $stats['pemilih']) * 100, 1) }}%
              </span>
            @else
              <span class="text-sm font-bold text-slate-400">0%</span>
            @endif
          </div>
          <div class="mt-2 bg-slate-200 rounded-full h-2">
            @if($stats['pemilih'] > 0)
              <div class="bg-gradient-to-r from-purple-500 to-pink-600 h-2 rounded-full transition-all duration-500" 
                   style="width: {{ ($stats['sudah_memilih'] / $stats['pemilih']) * 100 }}%"></div>
            @else
              <div class="bg-slate-300 h-2 rounded-full" style="width: 0%"></div>
            @endif
          </div>
        </div>
      </div>

      <!-- Kandidat -->
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden group hover:shadow-xl transition-all duration-300">
        <div class="bg-gradient-to-r from-amber-500 to-orange-600 p-6 text-white">
          <div class="flex items-center justify-between">
            <div>
              <p class="text-amber-100 text-sm font-medium">Total Kandidat</p>
              <p class="text-2xl font-bold mt-1">{{ number_format($stats['kandidat']) }}</p>
            </div>
            <div class="bg-white/20 p-3 rounded-full">
              <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M10 2a4 4 0 00-4 4v1H5a1 1 0 00-.994.89l-1 9A1 1 0 004 18h12a1 1 0 00.994-1.11l-1-9A1 1 0 0015 7h-1V6a4 4 0 00-4-4zM8 6a2 2 0 114 0v1H8V6z" clip-rule="evenodd"/>
              </svg>
            </div>
          </div>
        </div>
        <div class="p-4">
          <div class="flex items-center text-sm text-amber-600">
            <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M11.3 1.046A1 1 0 0112 2v5h4a1 1 0 01.82 1.573l-7 10A1 1 0 018 18v-5H4a1 1 0 01-.82-1.573l7-10a1 1 0 011.12-.38z" clip-rule="evenodd"/>
            </svg>
            Kandidat Terdaftar
          </div>
        </div>
      </div>
    </div>

    <!-- Rekap Suara Section -->
    <div class="grid lg:grid-cols-3 gap-8">
      <!-- Chart Section -->
      <div class="lg:col-span-1">
        <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
          <div class="bg-gradient-to-r from-slate-800 to-slate-900 p-6 text-white">
            <div class="flex items-center">
              <div class="bg-white/20 p-3 rounded-full mr-4">
                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M3 3a1 1 0 000 2v8a2 2 0 002 2h2.586l-1.293 1.293a1 1 0 101.414 1.414L10 15.414l2.293 2.293a1 1 0 001.414-1.414L12.414 15H15a2 2 0 002-2V5a1 1 0 100-2H3zm11.707 4.707a1 1 0 00-1.414-1.414L10 9.586 8.707 8.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
              </div>
              <div>
                <h3 class="text-lg font-semibold">Visualisasi Suara</h3>
                <p class="text-slate-300 text-sm">Grafik perolehan suara</p>
              </div>
            </div>
          </div>
          <div class="p-6">
            <div class="space-y-4">
              @forelse($rekap as $index => $r)
                @php
                  $colors = ['bg-blue-500', 'bg-emerald-500', 'bg-purple-500', 'bg-amber-500', 'bg-pink-500', 'bg-indigo-500'];
                  $color = $colors[$index % count($colors)];
                  $maxVotes = $rekap->max('votes') ?: 1;
                  $percentage = $maxVotes > 0 ? ($r->votes / $maxVotes) * 100 : 0;
                @endphp
                <div class="space-y-2">
                  <div class="flex items-center justify-between text-sm">
                    <span class="font-medium text-slate-700">{{ $r->number }}. {{ Str::limit($r->name, 20) }}</span>
                    <span class="font-bold text-slate-900">{{ $r->votes }}</span>
                  </div>
                  <div class="bg-slate-200 rounded-full h-2">
                    <div class="{{ $color }} h-2 rounded-full transition-all duration-1000 ease-out" 
                         style="width: {{ $percentage }}%"></div>
                  </div>
                </div>
              @empty
                <div class="text-center py-8">
                  <svg class="w-12 h-12 mx-auto text-slate-400 mb-4" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"/>
                  </svg>
                  <p class="text-slate-500">Belum ada data suara</p>
                </div>
              @endforelse
            </div>
          </div>
        </div>
      </div>

      <!-- Table Section -->
      <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
          <div class="bg-gradient-to-r from-slate-800 to-slate-900 p-6 text-white">
            <div class="flex items-center justify-between">
              <div>
                <h3 class="text-lg font-semibold mb-1">Rekap Perolehan Suara</h3>
                <p class="text-slate-300 text-sm">Data real-time hasil pemilihan</p>
              </div>
              <div class="flex items-center gap-2">
                <div class="bg-white/10 px-3 py-1 rounded-full">
                  <span class="text-xs font-medium">Total: {{ $rekap->sum('votes') }} suara</span>
                </div>
                <button onclick="window.location.reload()" 
                        class="bg-white/20 hover:bg-white/30 p-2 rounded-full transition-colors duration-200">
                  <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                    <path fill-rule="evenodd" d="M4 2a1 1 0 011 1v2.101a7.002 7.002 0 0111.601 2.566 1 1 0 11-1.885.666A5.002 5.002 0 005.999 7H9a1 1 0 010 2H4a1 1 0 01-1-1V3a1 1 0 011-1zm.008 9.057a1 1 0 011.276.61A5.002 5.002 0 0014.001 13H11a1 1 0 110-2h5a1 1 0 011 1v5a1 1 0 11-2 0v-2.101a7.002 7.002 0 01-11.601-2.566 1 1 0 01.61-1.276z" clip-rule="evenodd"/>
                  </svg>
                </button>
              </div>
            </div>
          </div>
          
          <div class="overflow-x-auto">
            <table class="w-full">
              <thead class="bg-slate-50 border-b border-slate-200">
                <tr>
                  <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Nomor</th>
                  <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Nama Kandidat</th>
                  <th class="px-6 py-4 text-center text-xs font-semibold text-slate-600 uppercase tracking-wider">Perolehan Suara</th>
                  <th class="px-6 py-4 text-center text-xs font-semibold text-slate-600 uppercase tracking-wider">Persentase</th>
                </tr>
              </thead>
              <tbody class="divide-y divide-slate-200">
                @forelse($rekap as $index => $r)
                  @php
                    $totalVotes = $rekap->sum('votes');
                    $percentage = $totalVotes > 0 ? ($r->votes / $totalVotes) * 100 : 0;
                    $colors = ['text-blue-600', 'text-emerald-600', 'text-purple-600', 'text-amber-600', 'text-pink-600'];
                    $bgColors = ['bg-blue-50', 'bg-emerald-50', 'bg-purple-50', 'bg-amber-50', 'bg-pink-50'];
                    $color = $colors[$index % count($colors)];
                    $bgColor = $bgColors[$index % count($bgColors)];
                  @endphp
                  <tr class="hover:bg-slate-50 transition-colors duration-150">
                    <td class="px-6 py-4 whitespace-nowrap">
                      <div class="flex items-center">
                        <span class="{{ $bgColor }} {{ $color }} w-8 h-8 rounded-full flex items-center justify-center text-sm font-bold mr-3">
                          {{ $r->number }}
                        </span>
                      </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                      <div class="font-semibold text-slate-900">{{ $r->name }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-center">
                      <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-bold {{ $bgColor }} {{ $color }}">
                        <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                          <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM6.293 6.707a1 1 0 010-1.414l3-3a1 1 0 011.414 0l3 3a1 1 0 01-1.414 1.414L11 5.414V13a1 1 0 11-2 0V5.414L7.707 6.707a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                        {{ number_format($r->votes) }}
                      </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-center">
                      <div class="flex items-center justify-center">
                        <span class="font-bold {{ $color }} mr-2">{{ number_format($percentage, 1) }}%</span>
                        <div class="w-16 bg-slate-200 rounded-full h-2">
                          <div class="bg-current h-2 rounded-full {{ $color }}" style="width: {{ $percentage }}%"></div>
                        </div>
                      </div>
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="4" class="px-6 py-12 text-center">
                      <div class="flex flex-col items-center">
                        <svg class="w-12 h-12 text-slate-400 mb-4" fill="currentColor" viewBox="0 0 20 20">
                          <path fill-rule="evenodd" d="M3 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 4a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"/>
                        </svg>
                        <p class="text-slate-500 text-lg font-medium mb-2">Belum ada data pemilihan</p>
                        <p class="text-slate-400 text-sm">Data akan muncul ketika pemilihan dimulai</p>
                      </div>
                    </td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
// Update current time
function updateTime() {
  const now = new Date();
  const timeString = now.toLocaleTimeString('id-ID', { 
    hour: '2-digit', 
    minute: '2-digit',
    second: '2-digit'
  });
  document.getElementById('current-time').textContent = timeString;
}

// Update time immediately and then every second
updateTime();
setInterval(updateTime, 1000);

// Auto refresh page every 30 seconds for live data
setInterval(() => {
  if (!document.hidden) {
    window.location.reload();
  }
}, 30000);
</script>

<style>
@keyframes fade-in {
  from { opacity: 0; transform: translateY(-10px); }
  to { opacity: 1; transform: translateY(0); }
}

.animate-fade-in {
  animation: fade-in 0.3s ease-out;
}

/* Pulse animation for live indicator */
@keyframes pulse {
  0%, 100% { opacity: 1; }
  50% { opacity: 0.5; }
}

.animate-pulse {
  animation: pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite;
}

/* Progress bar animations */
.progress-bar {
  transition: width 1s ease-in-out;
}

/* Hover effects */
.stat-card:hover {
  transform: translateY(-2px);
}
</style>
@endsection