@extends('layouts.app')
@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-4">
  <div class="max-w-4xl mx-auto">
    <!-- Header Section -->
    <div class="mb-8">
      <div class="flex items-center gap-4 mb-6">
        <a href="{{ route('admin.voters.index') }}" 
           class="group flex items-center gap-2 text-slate-600 hover:text-blue-600 transition-colors duration-200">
          <div class="bg-white group-hover:bg-blue-50 p-2 rounded-full shadow-sm border border-slate-200 group-hover:border-blue-300 transition-all duration-200">
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clip-rule="evenodd"/>
            </svg>
          </div>
          <span class="font-medium">Kembali ke Daftar Pemilih</span>
        </a>
      </div>
      
      <div>
        <h1 class="text-4xl font-bold bg-gradient-to-r from-blue-600 to-indigo-600 bg-clip-text text-transparent mb-2">
          Tambah Pemilih Manual
        </h1>
        <p class="text-slate-600">Masukkan data pemilih baru secara manual</p>
      </div>
    </div>

    <!-- Error Messages -->
    @if ($errors->any())
    <div class="mb-6 bg-red-50 border-l-4 border-red-500 rounded-r-lg p-4 animate-fade-in">
      <div class="flex items-start">
        <svg class="w-5 h-5 text-red-500 mt-0.5 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
        </svg>
        <div>
          <h3 class="text-red-800 font-medium mb-2">Terdapat kesalahan dalam form:</h3>
          <ul class="text-red-700 space-y-1">
            @foreach ($errors->all() as $error)
              <li class="flex items-start">
                <svg class="w-4 h-4 mt-0.5 mr-2 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                </svg>
                {{ $error }}
              </li>
            @endforeach
          </ul>
        </div>
      </div>
    </div>
    @endif

    <!-- Form Card -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden">
      <div class="bg-gradient-to-r from-blue-500 to-indigo-600 p-6 text-white">
        <div class="flex items-center">
          <div class="bg-white/20 p-3 rounded-full mr-4">
            <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
              <path d="M8 9a3 3 0 100-6 3 3 0 000 6zM8 11a6 6 0 016 6H2a6 6 0 016-6zM16 7a1 1 0 10-2 0v1h-1a1 1 0 100 2h1v1a1 1 0 102 0v-1h1a1 1 0 100-2h-1V7z"/>
            </svg>
          </div>
          <div>
            <h2 class="text-xl font-semibold">Form Data Pemilih</h2>
            <p class="text-blue-100 text-sm">Lengkapi informasi pemilih di bawah ini</p>
          </div>
        </div>
      </div>

      <form method="POST" action="{{ route('admin.voters.store') }}" class="p-6">
        @csrf
        <div class="grid md:grid-cols-2 gap-6">
          <!-- NIS Field -->
          <div class="space-y-2">
            <label class="block text-sm font-semibold text-slate-700 mb-2">
              <span class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-slate-500" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M10 2a4 4 0 00-4 4v1H5a1 1 0 00-.994.89l-1 9A1 1 0 004 18h12a1 1 0 00.994-1.11l-1-9A1 1 0 0015 7h-1V6a4 4 0 00-4-4zM8 6a2 2 0 114 0v1H8V6z" clip-rule="evenodd"/>
                </svg>
                NIS <span class="text-red-500 ml-1">*</span>
              </span>
            </label>
            <input name="nis" type="text"
                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 bg-white hover:border-slate-400" 
                   value="{{ old('nis') }}" placeholder="Masukkan NIS siswa" required>
            <p class="text-xs text-slate-500">Nomor Induk Siswa yang unik</p>
          </div>

          <!-- Nama Field -->
          <div class="space-y-2">
            <label class="block text-sm font-semibold text-slate-700 mb-2">
              <span class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-slate-500" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                </svg>
                Nama Lengkap <span class="text-red-500 ml-1">*</span>
              </span>
            </label>
            <input name="name" type="text"
                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 bg-white hover:border-slate-400" 
                   value="{{ old('name') }}" placeholder="Masukkan nama lengkap siswa" required>
            <p class="text-xs text-slate-500">Nama lengkap sesuai data sekolah</p>
          </div>

          <!-- Kelas Field -->
          <div class="space-y-2">
            <label class="block text-sm font-semibold text-slate-700 mb-2">
              <span class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-slate-500" fill="currentColor" viewBox="0 0 20 20">
                  <path d="M10.394 2.08a1 1 0 00-.788 0l-7 3a1 1 0 000 1.84L5.25 8.051a.999.999 0 01.356-.257l4-1.714a1 1 0 11.788 1.838L7.667 9.088l1.94.831a1 1 0 00.787 0l7-3a1 1 0 000-1.838l-7-3zM3.31 9.397L5 10.12v4.102a8.969 8.969 0 00-1.05-.174 1 1 0 01-.89-.89 11.115 11.115 0 01.25-3.762zM9.3 16.573A9.026 9.026 0 007 14.935v-3.957l1.818.78a3 3 0 002.364 0l5.508-2.361a11.026 11.026 0 01.25 3.762 1 1 0 01-.89.89 8.968 8.968 0 00-5.35 2.524 1 1 0 01-1.4 0zM6 18a1 1 0 001-1v-2.065a8.935 8.935 0 00-2-.712V17a1 1 0 001 1z"/>
                </svg>
                Kelas
              </span>
            </label>
            <input name="class" type="text"
                   class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 bg-white hover:border-slate-400" 
                   value="{{ old('class') }}" placeholder="Contoh: X-4, XI IPA 2, XII IPS 1">
            <p class="text-xs text-slate-500">Kelas siswa saat ini (opsional)</p>
          </div>

          <!-- Status Aktif -->
          <div class="space-y-2">
            <label class="block text-sm font-semibold text-slate-700 mb-3">
              <span class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-slate-500" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                </svg>
                Status Pemilih
              </span>
            </label>
            <div class="bg-slate-50 p-4 rounded-lg border border-slate-200">
              <label class="flex items-center justify-between cursor-pointer">
                <div class="flex items-center">
                  <span class="text-sm font-medium text-slate-700">Aktifkan pemilih?</span>
                  <span class="ml-2 text-xs text-slate-500">(Dapat memilih dalam pemilihan)</span>
                </div>
                <div class="relative">
                  {{-- kirim 0 saat unchecked --}}
                  <input type="hidden" name="is_active" value="0">
                  <input type="checkbox" name="is_active" value="1"
                         class="sr-only peer" {{ old('is_active', true) ? 'checked' : '' }}>
                  <div class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-slate-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600"></div>
                </div>
              </label>
            </div>
          </div>

          <!-- Generate PIN -->
          <div class="md:col-span-2 space-y-2">
            <label class="block text-sm font-semibold text-slate-700 mb-3">
              <span class="flex items-center">
                <svg class="w-4 h-4 mr-2 text-slate-500" fill="currentColor" viewBox="0 0 20 20">
                  <path fill-rule="evenodd" d="M18 8A6 6 0 006 8v4.586l-2.293-2.293a1 1 0 00-1.414 1.414l4 4a1 1 0 001.414 0l4-4a1 1 0 00-1.414-1.414L8 12.586V8a4 4 0 118 0v5a2 2 0 11-4 0V8a6 6 0 012 11.472" clip-rule="evenodd"/>
                </svg>
                PIN Akses
              </span>
            </label>
            <div class="bg-amber-50 p-4 rounded-lg border border-amber-200">
              <label class="flex items-center justify-between cursor-pointer">
                <div class="flex items-center">
                  <span class="text-sm font-medium text-slate-700">Langsung terbitkan PIN untuk periode aktif?</span>
                  <span class="ml-2 text-xs text-amber-600">(PIN akan digunakan untuk login pemilihan)</span>
                </div>
                <div class="relative">
                  {{-- kirim 0 saat unchecked --}}
                  <input type="hidden" name="generate_pin" value="0">
                  <input type="checkbox" name="generate_pin" value="1"
                         class="sr-only peer" {{ old('generate_pin') ? 'checked' : '' }}>
                  <div class="w-11 h-6 bg-slate-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-amber-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-slate-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-amber-500"></div>
                </div>
              </label>
            </div>
          </div>
        </div>

        <!-- Action Buttons -->
        <div class="flex flex-col sm:flex-row gap-3 pt-6 mt-6 border-t border-slate-200">
          <a href="{{ route('admin.voters.index') }}" 
             class="flex-1 bg-white border-2 border-slate-300 hover:border-slate-400 text-slate-700 hover:text-slate-800 px-6 py-3 rounded-lg font-medium transition-all duration-200 text-center">
            <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
            </svg>
            Batal
          </a>
          <button type="submit" 
                  class="flex-1 bg-gradient-to-r from-blue-500 to-indigo-600 hover:from-blue-600 hover:to-indigo-700 text-white px-6 py-3 rounded-lg font-medium transition-all duration-200 transform hover:scale-[1.02] hover:shadow-lg">
            <svg class="w-4 h-4 inline mr-2" fill="currentColor" viewBox="0 0 20 20">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414 1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
            </svg>
            Simpan Pemilih
          </button>
        </div>
      </form>
    </div>

    <!-- Info Card -->
    <div class="mt-6 bg-blue-50 border border-blue-200 rounded-lg p-4">
      <div class="flex items-start">
        <svg class="w-5 h-5 text-blue-600 mt-0.5 mr-3 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
          <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
        </svg>
        <div>
          <h4 class="text-blue-900 font-medium mb-1">Informasi Tambahan</h4>
          <ul class="text-blue-800 text-sm space-y-1">
            <li>• NIS harus unik untuk setiap pemilih</li>
            <li>• Pemilih aktif dapat berpartisipasi dalam pemilihan</li>
            <li>• PIN akan digenerate otomatis jika dicentang</li>
            <li>• Data dapat diubah setelah disimpan melalui menu edit</li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
@keyframes fade-in { from { opacity: 0; transform: translateY(-10px); } to { opacity: 1; transform: translateY(0); } }
.animate-fade-in { animation: fade-in 0.3s ease-out; }
input[type="checkbox"]:checked + div { animation: toggle-on 0.2s ease-out; }
@keyframes toggle-on { 0% { background-color: #e2e8f0; } 100% { background-color: #2563eb; } }
</style>
@endsection
