@extends('layouts.app')

@section('content')
<!-- Header Section -->
<div class="mb-8">
    <div class="flex items-center justify-between">
        <div>
            <nav class="flex mb-4" aria-label="Breadcrumb">
                <ol class="inline-flex items-center space-x-1 md:space-x-3">
                    <li class="inline-flex items-center">
                        <a href="{{ route('admin.periods.index') }}" class="inline-flex items-center text-sm font-medium text-gray-700 hover:text-blue-600">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            Periode
                        </a>
                    </li>
                    <li>
                        <div class="flex items-center">
                            <svg class="w-6 h-6 text-gray-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                            </svg>
                            <span class="ml-1 text-sm font-medium text-gray-500 md:ml-2">Tambah Periode</span>
                        </div>
                    </li>
                </ol>
            </nav>
            <h1 class="text-3xl font-bold text-gray-800 flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 mr-3 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                </svg>
                Tambah Periode Baru
            </h1>
            <p class="text-gray-600 mt-2">Buat periode pemilihan OSIS dengan mengisi informasi di bawah ini</p>
        </div>
    </div>
</div>

<!-- Alert untuk Error Validation -->
@if($errors->any())
    <div class="alert alert-error mb-6 shadow-lg">
        <svg xmlns="http://www.w3.org/2000/svg" class="stroke-current shrink-0 h-6 w-6" fill="none" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z" />
        </svg>
        <div>
            <h3 class="font-bold">Terdapat kesalahan!</h3>
            <ul class="mt-2 list-disc list-inside">
                @foreach($errors->all() as $error)
                    <li class="text-sm">{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    </div>
@endif

<!-- Main Form Card -->
<div class="card bg-white shadow-xl border border-gray-100">
    <div class="card-body p-8">
        <form method="POST" action="{{ route('admin.periods.store') }}" id="periodForm" class="space-y-8">
            @csrf
            
            <!-- Form Header -->
            <div class="border-b border-gray-200 pb-6">
                <h2 class="text-xl font-semibold text-gray-800 flex items-center">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 mr-3 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                    </svg>
                    Informasi Periode
                </h2>
                <p class="text-gray-600 mt-1">Isi semua informasi yang diperlukan untuk periode pemilihan</p>
            </div>

            <!-- Form Fields -->
            <div class="grid md:grid-cols-2 gap-8">
                <!-- Nama Periode -->
                <div class="md:col-span-2">
                    <label class="form-control">
                        <div class="label">
                            <span class="label-text font-semibold text-gray-700 flex items-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2 text-blue-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z" />
                                </svg>
                                Nama Periode
                                <span class="text-red-500 ml-1">*</span>
                            </span>
                            <span class="label-text-alt text-gray-500">Contoh: Pemilihan OSIS 2024/2025</span>
                        </div>
                        <input name="name" 
                               value="{{ old('name') }}"
                               class="input input-bordered input-lg focus:input-primary transition-all duration-300 @error('name') input-error @enderror" 
                               placeholder="Masukkan nama periode pemilihan..."
                               required>
                        @error('name')
                            <div class="label">
                                <span class="label-text-alt text-error">{{ $message }}</span>
                            </div>
                        @enderror
                    </label>
                </div>

                <!-- Tanggal Mulai -->
                <div class="form-control">
                    <div class="label">
                        <span class="label-text font-semibold text-gray-700 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2 text-green-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            Tanggal & Waktu Mulai
                            <span class="text-red-500 ml-1">*</span>
                        </span>
                        <span class="label-text-alt text-gray-500">Kapan voting dimulai</span>
                    </div>
                    <input type="datetime-local" 
                           name="voting_start"
                           value="{{ old('voting_start') }}"
                           class="input input-bordered input-lg focus:input-primary transition-all duration-300 @error('voting_start') input-error @enderror"
                           required>
                    @error('voting_start')
                        <div class="label">
                            <span class="label-text-alt text-error">{{ $message }}</span>
                        </div>
                    @enderror
                </div>

                <!-- Tanggal Selesai -->
                <div class="form-control">
                    <div class="label">
                        <span class="label-text font-semibold text-gray-700 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2 text-red-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                            </svg>
                            Tanggal & Waktu Selesai
                            <span class="text-red-500 ml-1">*</span>
                        </span>
                        <span class="label-text-alt text-gray-500">Kapan voting berakhir</span>
                    </div>
                    <input type="datetime-local" 
                           name="voting_end"
                           value="{{ old('voting_end') }}"
                           class="input input-bordered input-lg focus:input-primary transition-all duration-300 @error('voting_end') input-error @enderror"
                           required>
                    @error('voting_end')
                        <div class="label">
                            <span class="label-text-alt text-error">{{ $message }}</span>
                        </div>
                    @enderror
                </div>
            </div>

            <!-- Status Aktif -->
            <div class="border-t border-gray-200 pt-6">
                <div class="flex items-center justify-between p-6 bg-gray-50 rounded-xl border border-gray-200">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                            </svg>
                        </div>
                        <div class="ml-4">
                            <h3 class="text-lg font-medium text-gray-800">Status Periode</h3>
                            <p class="text-sm text-gray-600">Aktifkan periode ini setelah dibuat? Periode aktif akan dapat digunakan untuk voting.</p>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <label class="label cursor-pointer flex items-center">
                            <input type="checkbox" 
                                   name="is_active" 
                                   value="1"
                                   {{ old('is_active') ? 'checked' : '' }}
                                   class="toggle toggle-primary toggle-lg mr-4">
                            <span class="label-text font-medium text-gray-700">Aktifkan Periode</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Info Box -->
            <div class="alert alert-info shadow-lg">
                <svg xmlns="http://www.w3.org/2000/svg" class="stroke-current shrink-0 h-6 w-6" fill="none" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <div>
                    <h3 class="font-bold">💡 Tips:</h3>
                    <div class="text-sm mt-1">
                        <ul class="list-disc list-inside space-y-1">
                            <li>Pastikan tanggal selesai lebih besar dari tanggal mulai</li>
                            <li>Hanya satu periode yang dapat aktif dalam satu waktu</li>
                            <li>Periode aktif akan langsung dapat digunakan untuk voting</li>
                        </ul>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row justify-between items-center pt-6 border-t border-gray-200 gap-4">
                <a href="{{ route('admin.periods.index') }}" 
                   class="btn btn-ghost btn-lg w-full sm:w-auto order-2 sm:order-1">
                    <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                    </svg>
                    Kembali
                </a>
                
                <div class="flex gap-3 w-full sm:w-auto order-1 sm:order-2">
                    <button type="button" 
                            onclick="resetForm()"
                            class="btn btn-outline btn-lg flex-1 sm:flex-none">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                        </svg>
                        Reset
                    </button>
                    <button type="submit" 
                            class="btn btn-primary btn-lg shadow-lg hover:shadow-xl transform hover:-translate-y-1 transition-all duration-300 flex-1 sm:flex-none">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7H5a2 2 0 00-2 2v6a2 2 0 002 2h2m0 0h10a2 2 0 002-2V7a2 2 0 00-2-2H8m0 0V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 012-2h4a2 2 0 012 2v4" />
                        </svg>
                        Simpan Periode
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Custom Scripts -->
<script>
function resetForm() {
    if (confirm('Apakah Anda yakin ingin mereset semua data yang telah diisi?')) {
        document.getElementById('periodForm').reset();
    }
}

// Validasi tanggal
document.addEventListener('DOMContentLoaded', function() {
    const startDate = document.querySelector('input[name="voting_start"]');
    const endDate = document.querySelector('input[name="voting_end"]');
    
    // Set minimal tanggal ke hari ini
    const now = new Date();
    const today = now.toISOString().slice(0, 16);
    startDate.setAttribute('min', today);
    endDate.setAttribute('min', today);
    
    startDate.addEventListener('change', function() {
        if (this.value) {
            endDate.setAttribute('min', this.value);
            if (endDate.value && endDate.value < this.value) {
                endDate.value = '';
                alert('Tanggal selesai tidak boleh lebih kecil dari tanggal mulai!');
            }
        }
    });
    
    endDate.addEventListener('change', function() {
        if (this.value && startDate.value && this.value < startDate.value) {
            this.value = '';
            alert('Tanggal selesai tidak boleh lebih kecil dari tanggal mulai!');
        }
    });
});
</script>

<!-- Custom Styles -->
<style>
.card {
    border-radius: 16px !important;
    overflow: hidden;
}

.form-control input:focus {
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
    border-color: #3b82f6;
}

.alert {
    border-radius: 12px !important;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}

.toggle:checked {
    background-color: #3b82f6;
    border-color: #3b82f6;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.card-body {
    animation: fadeIn 0.5s ease-out;
}

/* Custom input styling */
input[type="datetime-local"] {
    color-scheme: light;
}

input[type="datetime-local"]::-webkit-calendar-picker-indicator {
    filter: invert(0.5);
    cursor: pointer;
}
</style>
@endsection