<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
    Schema::create('ballots', function (Blueprint $t) {
        $t->id();
        $t->foreignId('period_id')->constrained()->cascadeOnDelete();
        $t->foreignId('voter_id')->constrained()->cascadeOnDelete();
        $t->timestamp('cast_at')->nullable();
        $t->string('hash')->index();
        $t->boolean('is_valid')->default(true);
        $t->string('ip')->nullable();
        $t->string('ua')->nullable();
        $t->timestamps();
        $t->unique(['period_id','voter_id']); // 1 pemilih 1 suara
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ballots');
    }
};
