<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
    Schema::create('voter_credentials', function (Blueprint $t) {
        $t->id();
        $t->foreignId('voter_id')->constrained()->cascadeOnDelete();
        $t->foreignId('period_id')->constrained()->cascadeOnDelete();
        $t->string('pin'); // hashed atau plaintext sementara (kita simpan hashed)
        $t->timestamp('used_at')->nullable();
        $t->timestamp('invalidated_at')->nullable();
        $t->timestamps();
        $t->unique(['voter_id','period_id']);
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('voter_credentials');
    }
};
