<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
    Schema::create('voters', function (Blueprint $t) {
        $t->id();
        $t->string('nis')->unique();
        $t->string('name');
        $t->string('class')->nullable();
        $t->date('dob')->nullable(); // opsional
        $t->boolean('is_active')->default(true);
        $t->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('voters');
    }
};
