<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void {
        Schema::create('periods', function (Blueprint $t) {
            $t->id();
            $t->string('name'); // "OSIS 2025/2026"
            $t->dateTime('voting_start')->nullable();
            $t->dateTime('voting_end')->nullable();
            $t->boolean('is_active')->default(true);
            $t->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('periods');
    }
};
