<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Period extends Model
{
    protected $fillable = ['name','voting_start','voting_end','is_active'];
    protected $casts = [
        'voting_start' => 'datetime',
        'voting_end'   => 'datetime',
        'is_active'    => 'boolean',
    ];

    public function candidates(): HasMany { return $this->hasMany(Candidate::class); }
    public function ballots(): HasMany { return $this->hasMany(Ballot::class); }

    public function votingIsOpen(): bool {
        $now = now();
        return $this->is_active && $this->voting_start && $this->voting_end
            && $now->between($this->voting_start, $this->voting_end);
    }
}
