<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Candidate extends Model
{
    protected $fillable = [
        'period_id','name','class','photo_path','vision','mission','sort_order','is_active'
    ];

    public function period()
    {
        return $this->belongsTo(Period::class);
    }

    // accessor url foto
    public function getPhotoUrlAttribute(): ?string
    {
        return $this->photo_path ? asset('storage/'.$this->photo_path) : null;
    }
}
