<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Ballot extends Model
{
    protected $fillable = [
        'period_id',
        'voter_id',
        'candidate_id', // <-- PALING PENTING
        'cast_at',
        'hash',
        'is_valid',
        'ip',
        'ua'
    ];
    protected $casts = ['cast_at'=>'datetime','is_valid'=>'boolean'];

    public function period(): BelongsTo { return $this->belongsTo(Period::class); }
    public function voter(): BelongsTo { return $this->belongsTo(Voter::class); }
    public function choices(): HasMany { return $this->hasMany(BallotChoice::class); }
}
