<?php

namespace App\Imports;

use App\Models\Voter;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithUpserts;

class VotersImport implements ToModel, WithHeadingRow, WithUpserts
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        // Pastikan kolom 'nis' dan 'name' tidak kosong sebelum diproses
        if (!isset($row['nis']) || !isset($row['name'])) {
            return null;
        }

        return new Voter([
            'nis'       => $row['nis'],
            'name'      => $row['name'],
            'class'     => $row['class'] ?? null,
            'is_active' => 1, // Otomatis set pemilih baru sebagai aktif
        ]);
    }

    /**
     * Tentukan kolom unik untuk operasi upsert.
     * Dalam kasus ini, 'nis' adalah kolom unik.
     */
    public function uniqueBy()
    {
        return 'nis';
    }
}