<?php

namespace App\Http\Controllers;

use App\Models\Period;
use App\Models\Voter;
use App\Models\VoterCredential;
use App\Models\Ballot;
use Illuminate\Http\Request;

class VoterAuthController extends Controller
{
    public function showLogin()
    {
        $period = Period::where('is_active',1)->latest()->first();
        return view('voter.login', compact('period'));
    }

    public function login(Request $request)
    {
        $data = $request->validate([
            'nis' => 'required|string',
            'pin' => 'required|string',
        ]);

        $period = Period::where('is_active',1)->latest()->first();
        if (!$period) return back()->with('error','Tidak ada periode aktif.');

        // cari voter aktif
        $voter = Voter::where('nis',$data['nis'])->where('is_active',1)->first();
        if (!$voter) return back()->with('error','NIS tidak ditemukan / tidak aktif.');

        // cek pin pada tabel voter_credentials (format: voter_id, period_id, pin)
        $cred = VoterCredential::where('voter_id',$voter->id)
                 ->where('period_id',$period->id)->first();

        if (!$cred || !password_verify((string)$data['pin'], $cred->pin)) {
            return back()->with('error','PIN salah untuk periode aktif.');
        }

        // sudah memilih?
        $already = Ballot::where('voter_id',$voter->id)
                    ->where('period_id',$period->id)->exists();
        if ($already) {
            // Simpan sesi sekadar agar bisa melihat halaman thanks
            session(['voter_id'=>$voter->id,'period_id'=>$period->id]);
            return redirect()->route('vote.thanks')->with('info','Anda sudah memberikan suara.');
        }

        // sukses → simpan sesi
        session([
            'voter_id'  => $voter->id,
            'period_id' => $period->id,
            'voter_name'=> $voter->name,
        ]);

        return redirect()->route('vote.home');
    }

    public function logout()
    {
        session()->forget(['voter_id','period_id','voter_name']);
        return redirect()->route('voter.login')->with('status','Berhasil keluar.');
    }
}
