<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Ballot;
use App\Models\Candidate;
use App\Models\Period;
use App\Models\Voter;
use Illuminate\Support\Facades\DB;

class AdminController extends Controller
{
    public function dashboard()
    {
        $period = Period::where('is_active',1)->latest()->first();
        $stats = [
            'period' => $period?->name ?? '-',
            'pemilih' => Voter::count(),
            'sudah_memilih' => $period ? Ballot::where('period_id',$period->id)->count() : 0,
            'kandidat' => $period ? Candidate::where('period_id',$period->id)->count() : 0,
        ];

        $rekap = [];
        if ($period) {
            $rekap = DB::table('candidates as c')
                ->leftJoin('ballot_choices as bc','bc.candidate_id','=','c.id')
                ->selectRaw('c.id, c.number, c.name, COUNT(bc.id) as votes')
                ->where('c.period_id',$period->id)
                ->groupBy('c.id','c.number','c.name')
                ->orderBy('c.number')
                ->get();
        }

        return view('admin.dashboard', compact('stats','rekap','period'));
    }
}
